module.exports = {
    HEADSET_STATUS: {
        HEADSET_DISCONNECTED: 0,
        HEADSET_CONNECTED: 1,
        HEADSET_GETTING_CONNECTED: 2,
        HEADSET_UNSUPPORTED: 3,
        HEADSET_REAL_DFU: 4,
        HEADSET_SIMULATED_DFU: 5
    },
    EVENTS: {
        SET_PSKEY: 'set-pskey',
        GET_PSKEYS: 'get-pskeys',
        FACTORY_RESET: 'factory-reset',
        FIRMWARE_UPDATE: 'firmware-update',
        RECOVERY_FIRMWARE_UPDATE: 'recovery-firmware-update',
        GET_GROUPS: 'get-groups',
        CREATE_GROUP: 'create-group',
        CREATE_GROUP_FOR_BATCHES: 'create-group-for-batches',
        DELETE_GROUP: 'delete-group',
        ADD_DEVICE: 'add-device',
        IS_DEVICE_CONNECTED: 'is-device-connected',
        IS_NEW_FIRMWARE: 'is-new-firmware',
        CREATE_PRESET: 'create-preset',
        GET_PRESETS: 'get-presets',
        DELETE_PRESET: 'delete-preset',
        SET_PRESET_PSKEY: 'set-preset-pskey',
        BATCH_FIRMWARE_UPDATE: 'batch-firmware-update',
        BATCH_PRESET: 'batch-preset',
        GET_LICENSE_DETAILS: 'get-license-details',
        GET_DEVICE_DETAILS: 'get-device-details',
        FATAL_USB_ERROR: 'fatal-usb-error'
    },
    PSKEYS: {
        voicePrompt: 'user_config.parameters.voice_prompt_enable',
        VAD: 'user_config.parameters.VAD_threshold',
        ASR: 'user_config.parameters.asr_enable',
        language: 'user_config.parameters.language',
        FMBand: 'user_config.parameters.FM_radio_band',
        enableFM: 'hw_config.fm_enable',
        RDS: 'user_config.parameters.RDS_enable',
        batteryType: 'hw_config.parameters.battery_type',
        parallelAudioMixing: 'user_config.parameters.parallel_audio_enable',
        twoWayRadioAudioMixing: 'user_config.parameters.two_way_mix_enable',
        twoWayRadioSharing: 'user_config.parameters.two_way_sharing',
        secondaryAudioVolume: 'volumes.parallel_mix',
        micSensitivity: 'user_config.parameters.mic_threshold', // TODO: What's the difference between this and micGain??
        LD: 'user_config.parameters.ld_enable',
        LDVolume: 'volumes.ld',
        LDAGC: 'ps_LDAGC', // This is currently not yet established in the FW
        selfHearing: 'user_config.parameters.self_hear_enable',
        selfHearingVolume: 'volumes.sh',
        btFriendlyName: 'user_config.friendly_name',
        speedDialNumber: 'user_config.speed_dial',
        emergencyDialNumber: 'user_config.emergency_dial',
        enableBT: 'hw_config.parameters.bt_enable',
        intercomChannel: 'user_config.parameters.grouping_channel',
        speakerGain: 'ps_speakerGain', // This is currently not yet established in the FW
        speakerSwitch: 'config_params.SwitchOutputSpeakersDirection', // ??
        VADGain: 'ps_VADGain', // ??
        micGain_low: 'mic_gain.mic_gain_low',
        micGain_med: 'mic_gain.mic_gain_med',
        micGain_high: 'mic_gain.mic_gain_high',
        chargeLEDLocation: 'hw_config.parameters.power_led_is_external',
        magicWord: 'hw_config.parameters.asr_magic_word_index',
        radioPresets: 'radio_config.station_frequency'
    },
    APPS: {
        current: 'updater', // TODO - should be dynamically provided by the app itself
        CONFIGURATOR: 'configurator',
        ADMIN: 'admin',
        UPDATER: 'updater'
    },
    SERVER_URL: 'https://update.cardosystems.com/cardo-fw/{model}/fw_info.json',
    MODEL_DEVICE_ERROR: 'DEV_UID_SIZE_ERR',
    MODEL_DEVICE_UNKNOWN: 'Unknown',
    MODEL_DEVICE_NOT_SUPPORTED: 'Not Supported',
    STATUS_DOWNLOADING_VERSION_INFO: 'downloading_version_info',
    STATUS_DOWNLOADING_FW: 'downloading_fw',
    STATUS_INSTALLING_FW: 'installing_fw',
    VERSION_STABLE: '__stable__',
    VERSION_BETA: '__beta__',
    MAX_GROUP_DEVICES: 15,
    BATCH_STATE: {
        READY: 1,
        PROCESSING: 2
    },

    MODELS: {
        PRO1: 'Pro1',
        PACKTALK_BOLD_JBL: 'Packtalk_Bold_JBL',
        PACKTALK_BLACK: 'Packtalk_Black',
        PACKTALK_DUCATI: 'Packtalk_Ducati',
        PACKTALK_SLIM_JBL: 'Packtalk_Slim_JBL',
        PACKTALK_BOLD: 'Packtalk_Bold',
        PACKTALK_SLIM: 'Packtalk_Slim',
        PACKTALK_SKI: 'Packtalk_Ski',
        PACKTALK: 'Packtalk',
        SMART_H: 'SmartH',
        SMARTPACK: 'Smartpack',
        FREECOM4PLUS: 'Freecom4plus',
        FREECOM4PLUSCR: 'Freecom4plusCR',
        FREECOM4: 'Freecom4',
        FREECOM2PLUS: 'Freecom2plus',
        FREECOM2: 'Freecom2',
        FREECOM1PLUS: 'Freecom1plus',
        FREECOM1FM: 'Freecom1fm',
        FREECOM1: 'Freecom1',
        TERRANOXT: 'TerranoXT',
        FREECOM_SOLO: 'FreecomSolo',
        PACKTALK_SLIM_AGV: 'Packtalk_Insyde',
        MCLAREN_INTERCOM: 'Packtalk_Slim_McLaren',
        PACKTALK_LOUIS: 'Packtalk_Louis',
        PACKTALK_BOLD_JBL_ICS00177: 'Packtalk_Bold_JBL_ICS00177',
        SKI_II_SINGLE_PACK: 'SKI_II_ICS00177',
        PACKTALK_BLACK_ICS00177: 'Packtalk_Black_ICS00177',
        PACKTALK_SLIM_JBL_ICS00177: 'Packtalk_Slim_JBL_ICS00177',
        PACKTALK_SLIM_MCLAREN_ICS00177: 'Packtalk_Slim_McLaren_ICS00177',
        PACKTALK_BOLD_LOUIS_NEW_FM_ICS: 'Packtalk_Louis_New_FM_ICS',
        SPIRIT: 'Spirit',
        SPIRIT_HD: 'SpiritHD',
        FRC2X: 'Freecom2X',
        FRC4X: 'Freecom4X',
        PACKTALK_EDGE: 'Packtalk_Edge',
        PACKTALK_EDGE_DUCATI: 'Packtalk_Edge_Ducati',
        PACKTALK_EDGE_KTM: 'Packtalk_Edge_KTM',
        PACKTALK_EDGE_HONDA: 'Packtalk_Edge_Honda',
        PT_OUTDOOR_CONSUMER: 'Packtalk_Outdoor_Consumer',
        PT_OUTDOOR_INSTRUCTOR: 'Packtalk_Outdoor_Instructor',
        PT_OUTDOOR_STUDENT: 'Packtalk_Outdoor_Student',
        PT_CUSTOM: 'Packtalk_Custom',
        PT_EDGE_SIMPSON: 'Packtalk_Edge_Simpson',
        PACKTALK_NEO: 'Packtalk_Neo',
        PACKTALK_ORV: 'Packtalk_ORV',
        PACKTALK_DELTA_V: 'Packtalk_Polaris_DV',
        UCS_LS2: 'LS2',
        PACKTALK_EDGE_HARLEY: 'Packtalk_Edge_Harley',
        FREECOM4X_HARLEY: 'Freecom4X_Harley',
        FREECOM2X_HARLEY: 'Freecom2X_Harley',
        PACKTALK_NEO_SE: 'Packtalk_Neo_SE',
        PACKTALK_EDGE_NO_FPGA: 'Packtalk_Edge_No_FPGA',
        PACKTALK_PRO: 'Packtalk_Pro',
        FC_MOTO_UCS: 'Fc_Moto_Ucs',
        GIVI_UCS: 'Givi_Ucs',
        SHOCKWAVE_MESH: 'Shockwave_Mesh',
        M509_UCS_SPIRIT: '509_Ucs_Spirit',
        PACKTALK_NEO_NO_FPGA: 'Packtalk_Neo_No_FPGA',
        PACKTALK_NEO_LOUIS: 'Packtalk_Neo_Louis',
        PACKTALK_OUTDOOR_FREEJUMP: 'Packtalk_Outdoor_Freejump',
        SCHUBERTH_SC_EDGE: 'Schuberth_SC_Edge'
    },
    // How the models should appear in the DB, in case their name is different than MODELS
    DB_MODEL_NAME: {
        Schuberth_SC_Edge: 'scEdge'
    }
};
